/** @file   eric.cpp
 * @brief   Implementation of Eric - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#include "eric.h"
#include "gameanims.h"
#include "animplayer.h"
#include "settings.h"
#include "youkocontroller.h"
#include "soundsamples.h"
#include "AnimId.h"
using namespace eng2d;

namespace WeWantWar {
///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
Eric::Eric() :
  NpcCharacter()
{
  int oid = ObjectID::TYPE_ERIC;
  this->setArmor( Settings::floatObjProp(oid, "armor:") );
  this->boundingSphere( Settings::floatObjProp(oid, "bsphere:") );
  m_movementVec.vy = - Settings::floatObjProp(oid, "walk_spd:");

  YoukoController* pC = new YoukoController( this );
  pC->youkoState( YoukoController::YOUKO_FIGHT );
  this->setController( pC );
  NpcCharacter::m_animationCombine = GameAnims::getAnimCombine( AnimId::KEric );
  const Animation& anim = m_animationCombine->FindAnim( GameAnims::EIdle );
  this->setAnimation( anim, GameAnims::EIdle );


  // Setup the sounds
  m_soundIndices.at( GameObject::SND_ATTACK ) = SMP_WEAPON1;
  
  NpcCharacter::m_weapon = Weapon( Weapon::W_RIFLE );
}



/** Destructor
 */
Eric::~Eric()
{
}




///
/// Public methods
/// ==============

/** Updates this object
 */
void Eric::update()
{
  if ( this->state() == GameObject::STATE_KILLED ) {
    return;
  }

  if ( this->state() == GameObject::STATE_DYING ) {
    if ( m_animation.paused() == true ) {
      this->state( GameObject::STATE_KILLED );
      this->changeAnimation( GameAnims::EKilled );
    }
    return;
  }

  YoukoController* pC = dynamic_cast<YoukoController*>( this->getController() );
  pC->update();
  this->changeAngle( pC->turn() );

  if ( pC->forward() == 0 ) {
    this->changeAnimation( GameAnims::EIdle );

  } else if ( pC->forward() == 1 ) {
    Vec2D mvec( m_movementVec );
    mvec.rotate( this->angle() );
    this->move( mvec );
    this->changeAnimation( GameAnims::EWalk );
  }

  if ( pC->shoot() != 0 ) {
    this->changeAnimation( GameAnims::EShoot );
    if ( this->reloading() == false ) {
      this->handleShooting();
    }
  }
}




///
/// Getter methods
/// ==============

/** Returns the type of this object
 */
ObjectID::Type Eric::objectType() const
{
  return ObjectID::TYPE_ERIC;
}



///
/// Private or Protected methods
/// ============================

} // end of namespace
